﻿var mySurveyTemplates = {
    context: $(".v-mySurveyTemplates"),
    templatesTable: null,
    treeview: null,
    previewFlag: true,
    parentFolderId: 1,
    showCreateSuccess: false,
    showImportSuccess: false,
    templateSource: null,
    importRedirect: function (id, name = '') {
        if (id !== 0) {
            importTemplate(-1, id, name);
        }
        a4.parent().mySurveyTemplates.refreshContent();
    },
    initializeDataTable: function (categoryRow) {
        $("#survey-templates").empty();
        mySurveyTemplates.showBusyBox();        
        var defaultParent = $("#hdnDefaultParentFolderId").val();
        var folderId = defaultParent != undefined && defaultParent != null ? parseInt(defaultParent) : 1;
        if (categoryRow) {
            folderId = categoryRow.Id;
        } else {
            var categoryId = $("#hdnCategoryId").val();
            var parentKey = categoryId != "" ? categoryId != "1" ? "1_" + parseInt(categoryId) : 1 : 1;
            $(".h-templateFolders").a4listview("highlightNode", parentKey);
        }
        var params = {
            parentFolderId: folderId
        };
        mySurveyTemplates.parentFolderId = folderId;
        a4.callServerMethod(a4.getAction("GetTemplateByCategoryId", "Templates", "Library"), params, function (response) {
            var templatesTable = response.aaData;
            mySurveyTemplates.templatesTable = templatesTable;
            mySurveyTemplates.hideBusyBox();
            if (templatesTable) {
                searchTemplates(true);
            }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-templateFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetTemplateCategories", "Templates", "Library"),
            saveState: true,
            stateKey: "MySurveyTemplates",
            showTooltip: true,
            expanded: true,
            draw: function (event, data) {
                var categoryRow = data.selectedNode;
                mySurveyTemplates.initializeDataTable(categoryRow);
            },
            selectNode: function (event, data) {
                if (data.selected) {
                    mySurveyTemplates.initializeDataTable(data.node);
                }
            },
            localizableTexts: { "Search": resources.SearchCategory }
        });
    },
    bindEvents: function () {
    },
    refreshContent: function () {
        mySurveyTemplates.treeview.a4listview("refresh");
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    }
}

$(document).ready(function () {
    if (mySurveyTemplates.context.length > 0) {
        mySurveyTemplates.initializeTreeView();
        $(".template-preview-container").hide();
    }

    $('#templateSearchInput').keypress(function (e) {
        if (e.which == 13) {
            searchTemplates();
        }
    });
});

function searchTemplates(fromCategory = false) {
    var input = document.getElementById("templateSearchInput");
    var editTemplateEnable = (String($("#hdnEditSurveyTemplatesEnabled").val()).toLowerCase() === 'true');
    mySurveyTemplates.templateSearchValue = input.value;
    var filter = input.value.toUpperCase();
    var emptyDataMessage = true;
    var templatesTable = mySurveyTemplates.templatesTable != undefined ? mySurveyTemplates.templatesTable : null;
    $("#survey-templates").empty();
    if (templatesTable && templatesTable.length > 0) {

        $(".search").show();
        for (var i = 0; i < templatesTable.length; i++) {
            if (templatesTable[i].Name.toUpperCase().indexOf(filter) != -1 || templatesTable[i].Description.toUpperCase().indexOf(filter) != -1) {
                emptyDataMessage = false;
                var imagesrc = "../Content/Images/img_offline_main.png";
                if (templatesTable[i].Imagestring != null && templatesTable[i].Imagestring != "") {
                    imagesrc = templatesTable[i].Imagestring;
                }
                var jqhtml = $("<div>")
                    .append($("<div onclick=\"templatePreview(" + templatesTable[i].Id + ",'" + templatesTable[i].Name.replace(/'/g, "&hh&") + "'," + templatesTable[i].NumberOfTimesUsed + ",'" + templatesTable[i].Description.replace(/'/g, "&hh&") + "','" + templatesTable[i].TimeToComplete + "'," + templatesTable[i].QuestionsCount+")\">").addClass("d-flex-template")
                        .append($("<div>").addClass("template-image-div")
                            .prepend('<img src="' + imagesrc + '" class="template-image" />'))
                        .append($("<div class='template-content-section'>")
                            .append($("<div>").addClass("template-title").attr("title", templatesTable[i].Name).append("<P>", templatesTable[i].Name))
                            .append($("<div>").addClass("template-Description").attr("title", templatesTable[i].Description).append("<P>", templatesTable[i].Description))
                            .append($("<div>").addClass("template-lastused")
                                .append($("<i class='fa fa-clock-o' aria-hidden='true'></i> <span> " + " " + templatesTable[i].TimeToComplete + "</span>"))
                                .append($(templatesTable[i].QuestionsCount == 0 && editTemplateEnable ? "<i class='fa fa-pencil-square-o edit-template-icon' aria-hidden='true' title='Edit Survey Template' onclick='importTemplate(" + i +")'></i>" : ""))
                            )
                        ));
                $("#survey-templates").append(jqhtml.html());
            }
        }
    } else if (fromCategory) {
        $(".search").hide();
        $("#noTemplates").removeClass('d-none');
        $("#alert-info-header").text(validationMessage.NoTemplateAlertHeader);
        $("#alert-info-descrition").text(validationMessage.NoTemplateAlertDescription);
    }
    if (!fromCategory && emptyDataMessage) {
        $("#noTemplates").removeClass('d-none');
        $("#alert-info-header").text(validationMessage.NoTemplateSearchAlertHeader + " " + mySurveyTemplates.templateSearchValue);
        $("#alert-info-descrition").text(validationMessage.NoTemplateSearchAlertDescription);
    }
    if (!emptyDataMessage) {
        $("#noTemplates").addClass('d-none');
    }
}

function createTemplate(key=0) {    
    mySurveyTemplates.previewFlag = false;
    modalDialog.showWindow(a4.getAction("CreateTemplate", "Templates", "Library", {}), 700, 750, {
        afterClose: function () {
            closeCreateTemplateWindow();
        }
    });
}

function closeCreateTemplateWindow() {
    a4.parent().mySurveyTemplates.previewFlag = true;
    if (a4.parent().mySurveyTemplates.showCreateSuccess || a4.parent().mySurveyTemplates.showImportSuccess) {
        if (a4.parent().mySurveyTemplates.showCreateSuccess) {
            a4.showSuccessMessage(validationMessage.SuccessTemplateCreation);
            a4.parent().mySurveyTemplates.showCreateSuccess = false;
        }
        if (a4.parent().mySurveyTemplates.showImportSuccess) {
            a4.showSuccessMessage(validationMessage.SuccessQuestionnaireImportation);
            a4.parent().mySurveyTemplates.showImportSuccess = false;
            a4.parent().mySurveyTemplates.refreshContent();
        }
    }
}

function importTemplate(key, id, name) {    
    if (key >= 0) {
        id = mySurveyTemplates.templatesTable[key].Id;
        name = mySurveyTemplates.templatesTable[key].Name;
    }
    var params = {
        id: id,
        name: name,
    };
    mySurveyTemplates.previewFlag = false;
    modalDialog.showWindow(a4.getAction("ImportTemplate", "Templates", "Library", params), 800, 1000, {
        afterClose: function () {
            closeCreateTemplateWindow();
        }
    });
}

function templatePreview(templateId, name, numberOfTimesUsed, description, timeToComplete, questionCount) {    
    if (mySurveyTemplates.previewFlag) {
        if (questionCount == 0) {
            a4.showErrorMessage(validationMessage.ErrorNoQuestion);
        } else {
            $("#new-btn-template").hide();
            $("#template-container").hide();
            $("#hdnTemplateId").val(templateId);
            var useS2 = $('input[name="UseS2"]:checked').val();
            name = name.replace(/&hh&/g, "'");
            description = description.replace(/&hh&/g, "'");
            var params = {
                templateId: templateId,
                name: name,
                useS2: useS2 != undefined ? useS2 : false
            };
            a4.callServerMethod(a4.getAction("GetTemplateForPreview", "Templates", "Library"),
                params, function (response) {
                    if (response.containsS2Question) {
                        a4.showErrorMessage(validationMessage.TemplateAvailableForS2);
                        closePreview();
                    } else {
                        $(".template-preview-container").show();
                        $("#template-name").text(response.name);
                        $("#template-description").text(description);
                        $("#template-Questions-count").text(response.questionsCount);
                        $("#template-frequency").text(numberOfTimesUsed);
                        $("#template-completiontime").text(timeToComplete);
                        $("#template-surveyname").text(response.name);
                        $("<iframe src='" + response.surveyEngineUrl + "' class='preview-iframe' frameborder='1' scrolling='yes' id='myFrame' height=500 width=870></iframe>").appendTo(".preview-template");
                    }
                });
        }
    }
}

function closePreview() {    
    $("#new-btn-template").show();
    $("#template-container").show();
    $(".preview-template").empty();
    $(".template-preview-container").hide();
    $("#surveyNameValidation").addClass('d-none');
}

function createSurvey() {
    var surveyName = $("#template-surveyname").val();
    var templateId = $("#hdnTemplateId").val();
    var folderId = $("#hdnFolderId").val();
    var useS2 = $('input[name="UseS2"]:checked').val();
    if (surveyName == null || surveyName == "") {
        $("#surveyNameValidation").removeClass('d-none');
        return false;
    }
    mySurveyTemplates.showBusyBox();
    var params = {
        Name: surveyName,
        TemplateId: templateId != "" ? parseInt(templateId) : 0,
        folderId: folderId != "" ? parseInt(folderId) : 0,
        useS2: useS2 != undefined && useS2 != "" && useS2 === "true" ? true : false,
    };
    a4.callServerMethod(a4.getAction("CreateSurveyByTemplate", "Templates", "Library"), params, function (response) {
        mySurveyTemplates.hideBusyBox();       
        window.location = a4.getSurveyAction("Edit", "Questionnaire", { surveyId: response.surveyId});
    });
}

